package ga.examples.quadratic;

import ga.core.goperators.IMutationOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.validation.GAContext;

public class QuadraticClusterMutationOp extends ProbabilityOp implements
    IMutationOp<QuadraticClusterIndividual> {

  public QuadraticClusterMutationOp(final int pMutate) {
    super(pMutate);
  }

  @Override
  public QuadraticClusterIndividual mutate(
      final QuadraticClusterIndividual individual, final GAContext context) {
    final QuadraticClusterIndividual newInd = individual.clone();
    if (doOperate()) {
      final int iMutate = getRandom().nextInt(
          QuadraticIndividual.PARAMETER_COUNT);

      final int oldNum = newInd.getGenotype().get(iMutate);

      final int newNum = (oldNum + getRandom().nextInt(
          QuadraticIndividual.MAX_NUM))
          % QuadraticIndividual.MAX_NUM;
      newInd.getGenotype().set(iMutate, newNum);
    }

    return newInd;
  }
}
